require 'rubygems'
require_relative '../../module/DriverUtility'
require_relative '../../module/database/MongoUtility'
require_relative 'cc_SM_request_helper'
require_relative '../rspec_helper'
require_relative '../../pages/community_care/community_Care_PageObject'

describe '[Story VAR-9559:VAR - Booked in CC - Request]
          [Story VAR-10457: CC - Appointment list details view]
          [STORY# VAR-11873: Appointment List: Community Care Appointment – update format]' do
  include DriverUtility
  include MongoUtility
  include OracleUtility

  before(:all) do

      initializeConfigurations(VAR_BASE_URL)
      @db = connectToMongoDB("var-utility")
      removeDocument("bookedCCAppointments", "550094300", @db)
      deleteAllCCRequestData
      stage_cc_data_reqst
      documentCCRequest('Boston Friendly Text')
      documentDetailcode
      insertDocument("bookedCCAppointments", documentCCintoMongo, @db)
      @cc_po = CommunityCare_PageObject.new(@driver)
      @landing_appointments = LandingAppointments.new(@driver)
      @appointmentTime = Time.now.strftime("%H:%M")
      @cc_po.common.loginEndsOnHome(pw_redacted)
      @location = "BOSTON HCS VAMC"
    end

    after(:all) do
      @cc_po.loginLogout.logout
    end


  context 'AC#VAR-11047|TC#VAR-11048:VAR - Booked in CC - Request
           AC#VAR-11049|VAR-11050 CC - Appointment list details view
          [AC#VAR-11993|TC#VAR-11994: Appointment List: VA Facility Appointment – update format]' do


     it 'Select Booked CC Request and Verify the content of Details View' do
      findCCrequestfromAppointmentTable
      @appointmentTime = @appointmentTime.gsub!(':', '')
      actual_content = @cc_po.communityCare.cc_request_details_element.text.split("\n")
      expected_content = [\
        "Community Appointment",
        "Disclaimer: Any future changes to this appointment that you make directly with the community provider listed below will not be reflected in the information below.",
        "Date and Time: " + getDayofWeek(getDateNthDaysFromNow(5,"%m/%d/%Y")) + "," + " #{getDateNthDaysFromNow(5,"%m/%d/%Y")}",
        @appointmentTime + " #{Time.now.zone}",
        "Add to Calendar",
        "Details: Community Appointment",
        "Smith's Care",
        "John Smith",
        "24664 Tribe Sq",
        "Dulles, VA 20166",
        "(333) 333-4444",
        "Need to cancel or update this appointment?",
        "Please contact the provider directly"
      ]
      compareContents(expected_content, actual_content)

     end

     it 'Verify Prepare for this appointment section' do
      actual_content = @cc_po.communityCare.cc_prepare_for_appt_element.text.split("\n")
      expected_content = [\
        "Prepare for this Appointment",
        "Instructions to Veteran",
        "Please bring two form of identification",
      ]
      compareContents(expected_content, actual_content)
     end

     it 'Should verify Appointment is displayed in list after app refresh' do
       button_element = @driver.button(:id => 'back-btn')
       @driver.execute_script("$(arguments[0]).click();",button_element)
       @cc_po.common.waitWhileSpinnerPresent
       @landing_appointments.clickRefresh
       @cc_po.common.waitWhileSpinnerPresent
       appointmentDate = "#{getDayofWeek(getDateNthDaysFromNow(5,"%m/%d/%Y"))}," + " #{getDateNthDaysFromNow(5,"%m/%d/%Y")}"
       sleep 2
       @landing_appointments.appointment_header_element.when_present(TIME_OUT_LIMIT)
       Watir::Wait.until {@landing_appointments.appointment_table_list_elements.length >= 1}
       all_appointments = @landing_appointments.list_of_appointments_elements
       appointment_to_verify = "View details for your appointment," + "\n" + "Date/Time:" + "\n" + "#{getDayofWeek(getDateNthDaysFromNow(5,"%m/%d/%Y"))}," + " #{getDateNthDaysFromNow(5,"%m/%d/%Y")}" + "\n" + "#{@appointmentTime}" + "\n" + "#{appointmentDate} #{@appointmentTime.gsub("", " ")}" + "\n" +"Details:" + "\n" + "Community Care Appointment" + "\n" +"John Smith" + "\n" + "Smith's Care" + "\n" + "24664 Tribe Sq" + "\n" + "Dulles, VA 20166" + "\n" + "(333) 333-4444" + "\n" + "Prepare/Join:" + "\n" +"Prepare for your appointment"
       p appointment_to_verify
       expect(@landing_appointments.verifyAppointmentDetailsInList(all_appointments, appointment_to_verify)).to eq(true)

     end

  end

end






